<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Profile;
use app\models\User;

class ProfileController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['cabinet', 'edit'],
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'], // только авторизованные пользователи
                    ],
                ],
            ],
        ];
    }

    // ✅ Личный кабинет
    public function actionCabinet()
    {
        $user = Yii::$app->user->identity;
        $profile = Profile::find()->where(['user_id' => $user->id])->one();

        return $this->render('cabinet', [
            'user' => $user,
            'profile' => $profile,
        ]);
    }

    // ✅ Редактирование профиля
    public function actionEdit()
    {
        $user = Yii::$app->user->identity;
        $profile = Profile::findOne(['user_id' => $user->id]);

        if (!$profile) {
            $profile = new Profile();
            $profile->user_id = $user->id;
        }

        if ($profile->load(Yii::$app->request->post()) && $profile->save()) {
            Yii::$app->session->setFlash('success', 'Профиль обновлён!');
            return $this->redirect(['cabinet']);
        }

        return $this->render('edit', ['model' => $profile]);
    }
    public function actionForm()
    {
        $user = Yii::$app->user->identity;

        // Проверяем, есть ли уже профиль
        $profile = Profile::findOne(['user_id' => $user->id]);
        if (!$profile) {
            $profile = new Profile();
            $profile->user_id = $user->id;
        }

        // Загрузка данных из POST
        if ($profile->load(Yii::$app->request->post()) && $profile->save()) {
            Yii::$app->session->setFlash('success', 'Анкета успешно сохранена!');
            return $this->redirect(['cabinet']);
        }

        return $this->render('form', [
            'model' => $profile,
        ]);
    }
}
