<?php
use yii\helpers\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>">
    <head>
        <meta charset="<?= Yii::$app->charset ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
        <style>
            body {
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
                background-color: #f8f9fa;
                color: #333;
                margin: 0;
                padding: 0;
            }

            .navbar {
                background-color: #fff;
                border-bottom: 1px solid #dee2e6;
                padding: 0.5rem 0;
                box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            }

            .navbar-brand {
                color: #495057;
                font-weight: 600;
                padding: 0.5rem 1rem;
            }

            .nav-link {
                color: #6c757d;
                padding: 0.5rem 1rem;
                border-radius: 4px;
                margin: 0 0.25rem;
            }

            .nav-link:hover {
                background-color: #f1f3f5;
                color: #495057;
            }

            .container {
                max-width: 1200px;
                margin: 0 auto;
                padding: 20px;
            }

            .content {
                background: #fff;
                border-radius: 6px;
                padding: 30px;
                box-shadow: 0 1px 3px rgba(0,0,0,0.05);
            }

            .btn {
                padding: 0.375rem 0.75rem;
                border-radius: 4px;
                border: 1px solid transparent;
                font-size: 0.875rem;
            }

            .btn-primary {
                background-color: #3b7ddd;
                border-color: #3b7ddd;
            }

            .btn-outline-primary {
                color: #3b7ddd;
                border-color: #3b7ddd;
            }

            .form-control {
                border: 1px solid #ced4da;
                border-radius: 4px;
                padding: 0.375rem 0.75rem;
                font-size: 0.875rem;
            }

            .form-control:focus {
                border-color: #3b7ddd;
                box-shadow: 0 0 0 0.2rem rgba(59, 125, 221, 0.25);
            }
        </style>
    </head>
    <body>
    <?php $this->beginBody() ?>

    <?php
    NavBar::begin([
        'brandLabel' => 'Отдел кадров',
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar navbar-expand-lg',
        ],
    ]);

    if (Yii::$app->user->isGuest) {
        $menuItems[] = ['label' => 'Вход', 'url' => ['/site/login']];
        $menuItems[] = ['label' => 'Регистрация', 'url' => ['/site/register']];
    } else {
        $menuItems[] = ['label' => 'Анкета', 'url' => ['/profile/form']];
        $menuItems[] = ['label' => 'Личный кабинет', 'url' => ['/profile/cabinet']];

        if (Yii::$app->user->identity->email === 'admin@mail.ru') {
            $menuItems[] = ['label' => 'Админ-панель', 'url' => ['/admin/index']];
        }

        $menuItems[] = '<li class="nav-item">'
            . Html::beginForm(['/site/logout'], 'post', ['class' => 'd-flex'])
            . Html::submitButton(
                'Выход (' . Yii::$app->user->identity->fio . ')',
                ['class' => 'btn btn-outline-primary']
            )
            . Html::endForm()
            . '</li>';
    }

    echo Nav::widget([
        'options' => ['class' => 'navbar-nav ms-auto'],
        'items' => $menuItems,
    ]);

    NavBar::end();
    ?>

    <div class="container">
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <div class="content">
            <?= $content ?>
        </div>
    </div>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>