<?php
use yii\helpers\Html;

$this->title = 'Личный кабинет';
?>
<div class="cabinet">
    <h1 class="mb-4"><?= Html::encode($this->title) ?></h1>

    <div class="card mb-4">
        <div class="card-body">
            <h5 class="card-title">Основная информация</h5>
            <dl class="row mb-0">
                <dt class="col-sm-3">ФИО</dt>
                <dd class="col-sm-9"><?= Html::encode($user->fio ?? '-') ?></dd>

                <dt class="col-sm-3">Email</dt>
                <dd class="col-sm-9"><?= Html::encode($user->email ?? '-') ?></dd>

                <dt class="col-sm-3">Телефон</dt>
                <dd class="col-sm-9"><?= Html::encode($user->phone ?? '-') ?></dd>

                <dt class="col-sm-3">Дата рождения</dt>
                <dd class="col-sm-9"><?= Html::encode($profile->birth_date ?? '-') ?></dd>

                <dt class="col-sm-3">Гражданство</dt>
                <dd class="col-sm-9"><?= Html::encode($profile->citizenship ?? '-') ?></dd>
            </dl>
        </div>
    </div>

    <?php if ($profile): ?>
        <div class="card mb-4">
            <div class="card-body">
                <h5 class="card-title">Паспортные данные</h5>
                <dl class="row mb-0">
                    <dt class="col-sm-3">Серия/Номер</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->passport_series ?? '') ?> <?= Html::encode($profile->passport_number ?? '') ?></dd>

                    <dt class="col-sm-3">Кем выдан</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->passport_issued_by ?? '-') ?></dd>

                    <dt class="col-sm-3">Дата выдачи</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->passport_issue_date ?? '-') ?></dd>

                    <dt class="col-sm-3">Адрес регистрации</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->registration_address ?? '-') ?></dd>
                </dl>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-body">
                <h5 class="card-title">Образование</h5>
                <dl class="row mb-0">
                    <dt class="col-sm-3">Уровень</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->education_level ?? '-') ?></dd>

                    <dt class="col-sm-3">Учебное заведение</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->education_institution ?? '-') ?></dd>

                    <dt class="col-sm-3">Специальность</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->specialty ?? '-') ?></dd>

                    <dt class="col-sm-3">Диплом</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->diploma_series ?? '') ?> №<?= Html::encode($profile->diploma_number ?? '') ?></dd>
                </dl>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-body">
                <h5 class="card-title">Работа</h5>
                <dl class="row mb-0">
                    <dt class="col-sm-3">Место работы</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->workplace ?? '-') ?></dd>

                    <dt class="col-sm-3">Должность</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->position ?? '-') ?></dd>

                    <dt class="col-sm-3">Стаж</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->work_experience ?? '-') ?> лет</dd>

                    <dt class="col-sm-3">Состояние здоровья</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->health_status ?? '-') ?></dd>
                </dl>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-body">
                <h5 class="card-title">Документы</h5>
                <dl class="row mb-0">
                    <dt class="col-sm-3">СНИЛС</dt>
                    <dd class="col-sm-9"><?= Html::encode($profile->snils ?? '-') ?></dd>
                </dl>
            </div>
        </div>
    <?php endif; ?>

    <div class="mt-4">
        <?= Html::a('Редактировать профиль', ['profile/edit'], ['class' => 'btn btn-outline-primary']) ?>
        <?= Html::a('Заполнить анкету', ['profile/form'], ['class' => 'btn btn-primary']) ?>
    </div>
</div>