<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Редактирование профиля';
?>
<div class="edit-form">
    <h1 class="mb-4"><?= Html::encode($this->title) ?></h1>

    <?php $form = ActiveForm::begin([
        'options' => ['enctype' => 'multipart/form-data'],
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'text-danger small']
        ]
    ]); ?>

    <div class="row">
        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Основная информация</h5>
            <?= $form->field($model, 'address')->textInput() ?>
            <?= $form->field($model, 'birth_date')->input('date') ?>
            <?= $form->field($model, 'gender')->dropDownList(['Мужской' => 'Мужской', 'Женский' => 'Женский'], ['prompt' => 'Выберите пол']) ?>
            <?= $form->field($model, 'citizenship')->textInput() ?>
        </div>

        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Контакты</h5>
            <?= $form->field($model, 'email')->input('email') ?>
            <?= $form->field($model, 'phone')->textInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Образование</h5>
            <?= $form->field($model, 'education_level')->textInput() ?>
            <?= $form->field($model, 'education_institution')->textInput() ?>
            <?= $form->field($model, 'specialty')->textInput() ?>
        </div>

        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Работа</h5>
            <?= $form->field($model, 'workplace')->textInput() ?>
            <?= $form->field($model, 'position')->textInput() ?>
            <?= $form->field($model, 'work_experience')->textInput(['type' => 'number']) ?>
        </div>
    </div>

    <?= $form->field($model, 'additional_info')->textarea(['rows' => 3]) ?>

    <div class="form-group mt-4">
        <?= Html::submitButton('Сохранить', ['class' => 'btn btn-primary px-4']) ?>
        <?= Html::a('Отмена', ['profile/cabinet'], ['class' => 'btn btn-outline-secondary']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>