<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Анкета сотрудника';
?>
<div class="anketa-form">
    <h1 class="mb-4"><?= Html::encode($this->title) ?></h1>
    <p class="text-muted mb-4">Заполните информацию о себе</p>

    <?php $form = ActiveForm::begin([
        'options' => ['enctype' => 'multipart/form-data'],
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'text-danger small']
        ]
    ]); ?>

    <div class="row">
        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Основная информация</h5>
            <?= $form->field($model, 'fio')->textInput(['readonly' => true]) ?>
            <?= $form->field($model, 'birth_date')->input('date') ?>
            <?= $form->field($model, 'gender')->dropDownList(['Мужской' => 'Мужской', 'Женский' => 'Женский'], ['prompt' => 'Выберите пол']) ?>
            <?= $form->field($model, 'citizenship')->textInput(['placeholder' => 'Российская Федерация']) ?>
            <?= $form->field($model, 'marital_status')->textInput(['placeholder' => 'Холост/Женат']) ?>
        </div>

        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Контакты</h5>
            <?= $form->field($model, 'phone')->textInput(['readonly' => true]) ?>
            <?= $form->field($model, 'email')->input('email', ['readonly' => true]) ?>
            <?= $form->field($model, 'address')->textInput(['placeholder' => 'Город, улица, дом']) ?>
            <?= $form->field($model, 'photoFile')->fileInput()->hint('JPG, PNG или PDF, до 10МБ') ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Паспортные данные</h5>
            <?= $form->field($model, 'passport_series')->textInput(['placeholder' => '0000']) ?>
            <?= $form->field($model, 'passport_number')->textInput(['placeholder' => '000000']) ?>
            <?= $form->field($model, 'passport_issued_by')->textInput(['placeholder' => 'Кем выдан']) ?>
            <?= $form->field($model, 'passport_issue_date')->input('date') ?>
            <?= $form->field($model, 'registration_address')->textInput(['placeholder' => 'Адрес регистрации']) ?>
            <?= $form->field($model, 'passportFile')->fileInput()->hint('JPG, PNG или PDF, до 20МБ') ?>
        </div>

        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Образование</h5>
            <?= $form->field($model, 'education_level')->dropDownList([
                'Основное общее' => 'Основное общее',
                'Среднее общее' => 'Среднее общее',
                'Среднее профессиональное' => 'Среднее профессиональное',
                'Высшее' => 'Высшее'
            ], ['prompt' => 'Выберите уровень']) ?>
            <?= $form->field($model, 'education_institution')->textInput(['placeholder' => 'Название учебного заведения']) ?>
            <?= $form->field($model, 'specialty')->textInput(['placeholder' => 'Специальность']) ?>
            <?= $form->field($model, 'diploma_series')->textInput(['placeholder' => 'Серия диплома']) ?>
            <?= $form->field($model, 'diploma_number')->textInput(['placeholder' => 'Номер диплома']) ?>
            <?= $form->field($model, 'diplomaFile')->fileInput()->hint('JPG, PNG или PDF, до 20МБ') ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Работа</h5>
            <?= $form->field($model, 'workplace')->textInput(['placeholder' => 'Название организации']) ?>
            <?= $form->field($model, 'position')->textInput(['placeholder' => 'Должность']) ?>
            <?= $form->field($model, 'work_experience')->textInput(['type' => 'number', 'placeholder' => 'В годах']) ?>
            <?= $form->field($model, 'health_status')->textInput(['placeholder' => 'Общее состояние здоровья']) ?>
        </div>

        <div class="col-md-6">
            <h5 class="mt-4 mb-3">Документы</h5>
            <?= $form->field($model, 'snils')->textInput(['placeholder' => '000-000-000 00']) ?>
            <?= $form->field($model, 'snilsFile')->fileInput()->hint('JPG, PNG или PDF, до 10МБ') ?>
        </div>
    </div>

    <?= $form->field($model, 'additional_info')->textarea(['rows' => 4, 'placeholder' => 'Дополнительная информация']) ?>

    <div class="form-group mt-4">
        <?= Html::submitButton('Сохранить анкету', ['class' => 'btn btn-primary px-4']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>