<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Авторизация';
?>
<div class="login-form">
    <h1 class="mb-4"><?= Html::encode($this->title) ?></h1>

    <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'text-danger small']
        ]
    ]); ?>

    <?= $form->field($model, 'email')->textInput(['placeholder' => 'example@mail.ru']) ?>

    <?= $form->field($model, 'password')->passwordInput() ?>

    <div class="form-group mt-4">
        <?= Html::submitButton('Войти', ['class' => 'btn btn-primary px-4']) ?>
    </div>

    <?php ActiveForm::end(); ?>

    <div class="mt-4 text-center">
        <?= Html::a('Нет аккаунта? Зарегистрироваться', ['/site/register'], ['class' => 'text-decoration-none']) ?>
    </div>
</div>