<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Регистрация';
?>
<div class="signup-form">
    <h1 class="mb-4"><?= Html::encode($this->title) ?></h1>
    <p class="text-muted mb-4">Заполните форму для создания аккаунта</p>

    <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'text-danger small']
        ]
    ]); ?>

    <?= $form->field($model, 'fio')->textInput([
        'placeholder' => 'Иванов Иван Иванович'
    ])->label('ФИО') ?>

    <?= $form->field($model, 'phone')->textInput([
        'placeholder' => '+7(999)999-99-99'
    ])->label('Телефон') ?>

    <?= $form->field($model, 'email')->input('email', [
        'placeholder' => 'example@mail.ru'
    ])->label('Email') ?>

    <?= $form->field($model, 'password')->passwordInput()->label('Пароль') ?>

    <?= $form->field($model, 'password_repeat')->passwordInput()->label('Повторите пароль') ?>

    <?= $form->field($model, 'agree')->checkbox()->label('Я согласен с правилами регистрации') ?>

    <div class="form-group mt-4">
        <?= Html::submitButton('Создать аккаунт', ['class' => 'btn btn-primary px-4']) ?>
    </div>

    <?php ActiveForm::end(); ?>

    <div class="mt-4 text-center">
        <?= Html::a('Уже есть аккаунт? Войти', ['/site/login'], ['class' => 'text-decoration-none']) ?>
    </div>
</div>